/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.postprocessors.methodinvoker;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.PostProcessor;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.ExposeMethodParam;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.ExposeMethodResult;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.gson.FireExclusionStrategy;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.gson.FireExclusionStrategyComposite;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.postprocessors.methodinvoker.MappedMethod;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.postprocessors.methodinvoker.MappedMethodParamInspector;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.postprocessors.methodinvoker.MappedMethodResultInspector;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.util.reflection.AnnotationInspector;

public final class MethodInvokerPostProcessor<T>
implements PostProcessor<T> {
    private static AnnotationInspector<Method, MappedMethod> methodResultInspector = new MappedMethodResultInspector();
    private static AnnotationInspector<Method, MappedMethod> methodParamInspector = new MappedMethodParamInspector();
    private final FireExclusionStrategy serializationExclusionStrategy;
    private final boolean enableMethodParam;
    private final boolean enableMethodResult;

    public MethodInvokerPostProcessor() {
        this(false, true);
    }

    public MethodInvokerPostProcessor(FireExclusionStrategy serializationExclusionStrategy) {
        this(serializationExclusionStrategy, false, true);
    }

    public MethodInvokerPostProcessor(boolean enableMethodParam, boolean enableMethodResult) {
        this(new FireExclusionStrategyComposite(new FireExclusionStrategy[0]), enableMethodParam, enableMethodResult);
    }

    public MethodInvokerPostProcessor(FireExclusionStrategy serializationExclusionStrategy, boolean enableMethodParam, boolean enableMethodResult) {
        this.serializationExclusionStrategy = serializationExclusionStrategy;
        this.enableMethodParam = enableMethodParam;
        this.enableMethodResult = enableMethodResult;
    }

    @Override
    public void postDeserialize(T result, JsonElement src, Gson gson) {
        if (this.enableMethodParam && src.isJsonObject()) {
            JsonObject jsonObject = src.getAsJsonObject();
            for (MappedMethod m : methodParamInspector.getAnnotatedMembers(result.getClass(), ExposeMethodParam.class)) {
                if (this.serializationExclusionStrategy.shouldSkipMethod(m)) continue;
                try {
                    if (m.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.OVERWRITE && (m.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.SKIP || jsonObject.has(m.getSerializedName()))) continue;
                    Method method = m.getMethod();
                    Parameter param = method.getParameters()[0];
                    Object value = gson.fromJson(jsonObject.get(m.getSerializedName()), param.getParameterizedType());
                    method.invoke(result, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void postSerialize(JsonElement result, T src, Gson gson) {
        if (this.enableMethodResult && result.isJsonObject()) {
            JsonObject jsonObject = result.getAsJsonObject();
            for (MappedMethod m : methodResultInspector.getAnnotatedMembers(src.getClass(), ExposeMethodResult.class)) {
                if (this.serializationExclusionStrategy.shouldSkipMethod(m)) continue;
                try {
                    if (m.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.OVERWRITE && (m.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.SKIP || jsonObject.has(m.getSerializedName()))) continue;
                    Object value = m.getMethod().invoke(src, new Object[0]);
                    jsonObject.add(m.getSerializedName(), gson.toJsonTree(value));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

